/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.internal_users_db.InternalUser;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigUnavailableException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.dlic.rest.api.AbstractApiAction;
import com.floragunn.searchguard.dlic.rest.api.Endpoint;
import com.floragunn.searchguard.dlic.rest.api.PatchableResourceApiAction;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import com.floragunn.searchguard.dlic.rest.validation.InternalUsersValidator;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import java.io.IOException;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalUsersApiAction
extends PatchableResourceApiAction {
    @Inject
    public InternalUsersApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, StaticSgConfig staticSgConfig, ClusterService cs, PrincipalExtractor principalExtractor, AuthorizationService authorizationService, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, staticSgConfig, cs, principalExtractor, authorizationService, specialPrivilegesEvaluationContextProviderRegistry, threadPool, auditLog);
    }

    public List<RestHandler.Route> routes() {
        return this.getStandardResourceRoutes("internalusers");
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.INTERNALUSERS;
    }

    @Override
    protected void handlePut(final RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        SgDynamicConfiguration internaluser;
        SgDynamicConfiguration<InternalUser> configuration;
        final String username = request.param("name");
        if (username == null || username.length() == 0) {
            this.badRequestResponse(channel, "No " + this.getResourceName() + " specified.");
            return;
        }
        try {
            configuration = this.load(this.getConfigName(), false);
        }
        catch (ConfigUnavailableException e1) {
            this.internalErrorResponse(channel, e1.getMessage());
            return;
        }
        if (this.isHidden(configuration, username)) {
            this.forbidden(channel, "Resource '" + username + "' is not available.");
            return;
        }
        if (this.isReserved(configuration, username)) {
            this.forbidden(channel, "Resource '" + username + "' is read-only.");
            return;
        }
        String plainTextPassword = content.getAsString("password");
        String origHash = content.getAsString("hash");
        if (plainTextPassword != null && plainTextPassword.length() > 0) {
            content = content.without(new String[]{"password"}).with((Document)DocNode.of((String)"hash", (Object)InternalUsersApiAction.hash(plainTextPassword.toCharArray())));
        } else if (origHash != null && origHash.length() > 0) {
            content = content.without(new String[]{"password"});
        } else if (plainTextPassword != null && plainTextPassword.isEmpty() && origHash == null) {
            content = content.without(new String[]{"password"});
        }
        try {
            internaluser = this.load(CType.INTERNALUSERS, false);
        }
        catch (ConfigUnavailableException e1) {
            this.internalErrorResponse(channel, e1.getMessage());
            return;
        }
        final boolean userExisted = internaluser.exists(username);
        if (!userExisted && content.get("hash") == null) {
            this.badRequestResponse(channel, "Please specify either 'hash' or 'password' when creating a new internal user.");
            return;
        }
        if (userExisted && content.get("hash") == null) {
            String hash = ((InternalUser)internaluser.getCEntry(username)).getPasswordHash();
            if (hash == null || hash.length() == 0) {
                this.internalErrorResponse(channel, "Existing user " + username + " has no password, and no new password or hash was specified.");
                return;
            }
            content = content.with((Document)DocNode.of((String)"hash", (Object)hash));
        }
        String newJson = content.toJsonString();
        try {
            internaluser = internaluser.with(username, (Object)((InternalUser)InternalUser.parse((Object)DocReader.json().readObject(newJson), (Parser.Context)this.cl.getParserContext()).get()));
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException(e);
        }
        this.saveAnUpdateConfigs(client, request, CType.INTERNALUSERS, internaluser, new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                if (userExisted) {
                    InternalUsersApiAction.this.successResponse(channel, "'" + username + "' updated.");
                } else {
                    InternalUsersApiAction.this.createdResponse(channel, "'" + username + "' created.");
                }
            }
        });
    }

    @Override
    protected DocNode postProcessApplyPatchResult(RestChannel channel, RestRequest request, DocNode existingResourceAsJsonNode, DocNode updatedResourceAsJsonNode, String resourceName) throws ConfigValidationException {
        String plainTextPassword = updatedResourceAsJsonNode.getAsString("password");
        if (plainTextPassword != null) {
            LinkedHashMap<String, String> updatedResource = new LinkedHashMap<String, String>((Map<String, String>)updatedResourceAsJsonNode.toMap());
            String userName = resourceName;
            AbstractConfigurationValidator.ErrorType error = InternalUsersValidator.validatePassword(userName, plainTextPassword, this.settings);
            if (error != null) {
                throw new ConfigValidationException(new ValidationError("password", error.getMessage()));
            }
            updatedResource.remove("password");
            updatedResource.put("hash", InternalUsersApiAction.hash(plainTextPassword.toCharArray()));
            return DocNode.wrap(updatedResource);
        }
        return updatedResourceAsJsonNode;
    }

    public static String hash(char[] clearTextPassword) {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        String hash = OpenBSDBCrypt.generate((char[])Objects.requireNonNull(clearTextPassword), (byte[])salt, (int)12);
        Arrays.fill(salt, (byte)0);
        Arrays.fill(clearTextPassword, '\u0000');
        return hash;
    }

    @Override
    protected String getResourceName() {
        return "user";
    }

    protected CType<InternalUser> getConfigName() {
        return CType.INTERNALUSERS;
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... params) {
        return new InternalUsersValidator(request, ref, this.settings, params);
    }
}

